unit ThreadMMTUnit;

interface

uses  Windows, Classes, MMTimerUnit, Controls, SysUtils, StdCtrls, ExtCtrls,
      DateUtils;

type TSmThreadMMT = class(TThread)
  private
    fTID      : cardinal;  //   
    fCount    : cardinal;  //    
    // -----------------------------------------------------
    //     
    // -----------------------------------------------------
    fpTm       : TMMTimer;  //  TMMTimer
    fTmID     : cardinal;  //   
    fInterval : word;      //   
    fCicle    : boolean;   //    
    fEnabled  : boolean;   //   
    // -----------------------------------------------------
    //   
    // -----------------------------------------------------
    fTCur    : TDateTime;
    fTOld    : TDateTime;
    fPrefix  : string;
    // -----------------------------------------------------
    //   - VCL 
    // -----------------------------------------------------
    fRep      : TMemo;
    fPanel    : TPanel;   //  
    //  
    fEd1      : TEdit;
    fEd2   :    TEdit;
    // -----------------------------------------------------
    //     MMTimer
    procedure BuildMMTimer();
    //   VCL   fEd2.Text
    procedure SetToEd2();
    //   - " "
    procedure DoOnTimer(Sender : TObject);
    //  property Interval
    procedure SetInterval(RqInterval : word);
    //  property Cicle
    procedure SetCicle (RqCicle : boolean);
    //  property Enabled
    procedure SetEnabled (RqEnabled : boolean);
    //     MMTimer
    procedure FreeMMTimer();
    // -----------------------------------------------------
    //     VCL
    procedure BuildDynamicComponentsVCL();
    //     VCL
    procedure FreedDynamicComponentsVCL();

  protected
    procedure Execute; override;
    procedure TMTReports();
  public
    constructor Create(RqPanel : TPanel; RqRep : TMemo);
    destructor  Destroy(); reintroduce;
    // ---------------- 
    procedure   SetBeginTime();
    property Prefix   : string  read fPrefix  write  fPrefix;
    // ----------------
    property Interval : word    read fInterval write SetInterval;
    property Cicle    : boolean read fCicle    write SetCicle;
    property Enabled  : boolean read fEnabled  write SetEnabled;
end;


implementation

// ----------------------------------------------------------------
//  
// ----------------------------------------------------------------
// lass-reference.  ,    ,
//     TControl
type TControlClass = class of TControl;

// ----------------------------------------------------------------
//   ,   TControl.
//  CreateControl    class () 
// ,      RqOwner
// (,  Form1).

function CreateControl(ControlClass  : TControlClass;
                       RqOwner       : TWinControl;
                 const ComponentName : string;
                      X, Y, W, H     : Integer): TControl;
begin
    Result := ControlClass.Create(RqOwner);
    with Result do
    begin
      Parent := RqOwner;             //    
      Name := ComponentName;         //   
      SetBounds(X, Y, W, H);         //   TWinControl
      Visible := True;               //   
    end;
end;

// ----------------------------------------------------------------
//     TSmThread
// ----------------------------------------------------------------

//   VCL   fEd2.Text
procedure TSmThreadMMT.SetToEd2();
begin
  fTmID := Windows.GetCurrentThreadId;    //   
  fEd2.Text := 'Timer ID:' + IntToStr(Windows.GetCurrentThreadId);
end;

//   - "   "
//     Suspended 
//     Execute
procedure TSmThreadMMT.DoOnTimer(Sender : TObject);
begin
   if Assigned(fpTm)
   then begin
      if not (fTmID > 0)then Synchronize(SetToEd2);
      if fCicle
      then begin
         Enabled := True;
         Resume;
      end;
   end;
end;

//  property Interval
//    
procedure TSmThreadMMT.SetInterval(RqInterval : word);
begin
   if Assigned(fpTm) then fpTm.Interval := RqInterval;
end;

//  property Cicle
//    
procedure TSmThreadMMT.SetCicle (RqCicle : boolean);
begin
    fCicle := RqCicle;
end;

//  property Enabled
procedure TSmThreadMMT.SetEnabled (RqEnabled : boolean);
begin
  if Assigned(fpTm) then fpTm.Enabled := RqEnabled;
end;

//     MMTimer
procedure TSmThreadMMT.BuildMMTimer();
begin
  fpTm := TMMTimer.Create();
  fpTm.Interval  := 0;           //   
  fpTm.Cicle     := False;       //   
  fpTm.Enabled   := False;       //  
  fpTm.OnMMTimer := DoOnTimer;   //     
  Self.fTmID     := 0;           //    
end;

//     MM 
procedure TSmThreadMMT.FreeMMTimer();
begin
  if Assigned(fpTm)
  then begin
    //   ,   
    if not fpTm.Stoped then fpTm.Enabled := False;
    //       
    if not fpTm.Stoped then Sleep(1);
    Self.fTmID    := 0;           //    
    //    
    fpTm.Free;
    fpTm := nil;
  end;
end;

//     VCL
procedure TSmThreadMMT.BuildDynamicComponentsVCL();
var WName : string;
begin
  WName := 'Ed1ID' + IntToStr(fTID);
  fEd1  := (CreateControl(TEdit,fPanel,WName,10,10,100,24) as TEdit);
  fEd1.Text := 'Thead ID:' + IntToStr(fTID);
  WName := 'Ed2ID' + IntToStr(fTID);
  fEd2  := (CreateControl(TEdit,fPanel,WName,10,40,100,24) as TEdit);
  fEd2.Text := '';
end;

//     VCL
procedure TSmThreadMMT.FreedDynamicComponentsVCL();
begin
   if Assigned(fEd1) then fEd1.Free;
   if Assigned(fEd2) then fEd2.Free;
end;

constructor TSmThreadMMT.Create(RqPanel : TPanel; RqRep : TMemo);
begin
  inherited Create(True);
  fTID := ThreadID;
  //     MMTimer
  BuildMMTimer();
  //     VCL .
  fPanel := RqPanel;
  fRep   := RqRep;
  //     VCL
  Synchronize(BuildDynamicComponentsVCL);
  // ---------------- 
  fTOld := Now;    //    
  fTCur := fTOld;  //   
  // ----------------
end;

destructor TSmThreadMMT.Destroy();
begin
   //     MMTimer
   fTmID := 0;
   FreeMMTimer();
   //     VCL
   Synchronize(FreedDynamicComponentsVCL);
   //   
   if Suspended then Resume;
   Terminate;
   fTID := 0;
   inherited Destroy;
end;

//   
procedure TSmThreadMMT.Execute;
begin
  //     Suspended
  fCount := 0;
  repeat
    // ---------------- 
    fTOld := fTCur;  //    
    fTCur := Now;    //   
    // ----------------
    Synchronize(TMTReports);
    fCount := fCount + 1;
    Suspend;
  until (fCount > 1000) or Terminated;
  if not Terminated then Terminate;
end;

procedure TSmThreadMMT.SetBeginTime();
begin
   fTOld := Now;    //   
   fTCur := fTOld;
end;

//  (Sinhronize)
procedure TSmThreadMMT.TMTReports();
var WStr : string;
begin
   WStr := fPrefix + 'ID:'  + IntToStr(fTID)
   + '  Count='   + IntToStr(fCount)
   + '  Event:'   + IntToStr(fpTm.EvnID)
   + '  d(ms)='   + IntToStr(MilliSecondsBetween(fTCur, fTOld));
   fRep.Lines.Add(WStr);
end;

(*
// ===============================================================
//
//         TThread (UNIT Classes.pas)
//
// ===============================================================
// ---------------------------------------------------------------
//    / 
// ---------------------------------------------------------------
// UNIT System.pas
procedure ExitThread(ExitCode: Integer); stdcall;
                     external kernel name 'ExitThread';

//   -    
procedure TThread.DoTerminate;
begin
  if Assigned(FOnTerminate) then Synchronize(CallOnTerminate);
end;

procedure EndThread(ExitCode: Integer);
begin
  ExitThread(ExitCode);
end;

// ---------------------------------------------------------------
//     
// ---------------------------------------------------------------
function ThreadProc(Thread: TThread): Integer;
var
  FreeThread: Boolean;
begin
  try
    if not Thread.Terminated then
    try
      Thread.Execute;
    except
      Thread.FFatalException := AcquireExceptionObject;
    end;
  finally
    FreeThread := Thread.FFreeOnTerminate;
    Result := Thread.FReturnValue;
    Thread.DoTerminate;
    Thread.FFinished := True;
    SignalSyncEvent;
    if FreeThread then Thread.Free;
    EndThread(Result);
  end;
end;

procedure AddThread;
begin
  InterlockedIncrement(ThreadCount);
end;

constructor TThread.Create(CreateSuspended: Boolean);
begin
  inherited Create;
  AddThread;
  FSuspended := CreateSuspended;
  FCreateSuspended := CreateSuspended;
    // ---------------------------------------------
    //   (System.pas) -     ThreadProc
    // function BeginThread (SecurityAttributes: Pointer; StackSize: LongWord;
    //   ThreadFunc: TThreadFunc; Parameter: Pointer; CreationFlags: LongWord;
    //   var ThreadId: LongWord): Integer;
    // ---------------------------------------------
    FHandle := BeginThread(nil, 0, @ThreadProc, Pointer(Self), CREATE_SUSPENDED, FThreadID);
    // ---------------------------------------------
    if FHandle = 0 then
      raise EThread.CreateResFmt(@SThreadCreateError, [SysErrorMessage(GetLastError)]);
end;
// ---------------------------------------------------------------
//     
// ---------------------------------------------------------------
// UNIT Windows.pas
function CloseHandle; external kernel32 name 'CloseHandle';

procedure RemoveThread;
begin
  InterlockedDecrement(ThreadCount);  // Windows API
end;

destructor TThread.Destroy;
begin
  if (FThreadID <> 0) and not FFinished then
  begin
    Terminate;
    if FCreateSuspended then Resume;
    WaitFor;
  end;
  if FHandle <> 0 then CloseHandle(FHandle);
  inherited Destroy;
  FFatalException.Free;
  RemoveThread;
end;
// ==========================================================================
*)

end.
 